import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.geometry.*;
/**
 * This builds up a simple scene from primitives.
 * It builds a circular 'house' with a conical 'roof',
 * and then creates three 'trees' made up of cylinders
 * and spheres.  All this is place on a ground made up 
 * of a cube.
 * @author I.J.Palmer
 * @version 1.0
 */
public class SimpleCombine extends Frame implements ActionListener {
	protected Canvas3D myCanvas3D = new Canvas3D(null);
	protected Button myButton = new Button("Exit");
    /**
     * This function builds the view branch of the scene
     * graph.  It creates a branch group and then creates the
     * necessary view elements to give a useful view of our
     * content.
     * @param c Canvas3D that will display the view
     * @return BranchGroup that is the root of the view elements
     */
	protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
                viewXfm.set(new Vector3f(0.0f,0.0f,7.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		ViewPlatform myViewPlatform = new ViewPlatform();
           	PhysicalBody myBody = new PhysicalBody();
                PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
                myView.setPhysicalBody(myBody);
                myView.setPhysicalEnvironment(myEnvironment);
		return viewBranch;
	}
    /**
     * Add some lights so that we can illuminate the scene.
     * This adds one ambient light to bring up the overall 
     * lighting level and one directional shape to show
     * the shape of the objects in the scene.
     * @param b BranchGroup that the lights are to be added to.
     */
        protected void addLights(BranchGroup b) {
                BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
                Color3f lightColour1 = new Color3f(1.0f, 1.0f, 1.0f);
                Vector3f lightDir1  = new Vector3f(-1.0f, -1.0f, -1.0f);
                Color3f lightColour2 = new Color3f(1.0f, 1.0f, 1.0f);
                Vector3f lightDir2  = new Vector3f(1.0f, -1.0f, -1.0f);
                DirectionalLight light1 = new DirectionalLight(lightColour1, lightDir1);
                light1.setInfluencingBounds(bounds);
                DirectionalLight light2 = new DirectionalLight(lightColour2, lightDir2);
                light2.setInfluencingBounds(bounds);
                b.addChild(light1);
                b.addChild(light2);
        }
    /**
     * This builds the content branch of our scene graph.
     * The root of the shapes supplied as a parameter
     * is slightly tilted to reveal its 3D shape. It also uses
     * the addLights function to add some lights to the scene.
     * @param shape Node that represents the geometry for the content
     * @return BranchGroup that is the root of the content branch
     */
        protected BranchGroup buildContentBranch(Node shape) {
		BranchGroup contentBranch = new BranchGroup();
		Transform3D rotateCube = new Transform3D( );
                rotateCube.set(new AxisAngle4d(1.0,1.0,0.0,Math.PI/4.0));
		TransformGroup rotationGroup = new TransformGroup(rotateCube);
		contentBranch.addChild(rotationGroup);
                rotationGroup.addChild(shape);
                addLights(contentBranch);
		return contentBranch;
        } 
    /** 
     * This defines the shapes used in the scene.
     * The function uses the utility geometries sphere, box, cone
     * and cylinder to build a simple scene.  This demonstrates
     * the use of transformations to group and position items.
     * @return Node that is the root of the shape hierarchy.
     */
	protected Node buildShape() {
	        //Create a root for the shapes in the scene
                BranchGroup theScene = new BranchGroup();
                //Create an appearance for the ground
                Appearance groundApp = new Appearance();
                Color3f groundColour = new Color3f(0.0f,0.5f,0.0f);
                Color3f emissiveColour = new Color3f(0.0f,0.0f,0.0f);
                Color3f specularColour = new Color3f(0.5f,0.5f,0.5f);
                float shininess = 10.0f;
                groundApp.setMaterial(new Material(groundColour,emissiveColour,
                                        groundColour,specularColour,shininess));
                //Create a box that will be the ground
                Box ground = new Box(100.0f,0.1f,100.0f,groundApp);
                //Create a transform and a transform group that 
                //will position the ground
                Transform3D grndXfm = new Transform3D();
                grndXfm.set(new Vector3f(0.0f,-1.0f,0.0f));
                TransformGroup grndXfmGrp = new TransformGroup(grndXfm);
                //Add the ground shape to the group
                grndXfmGrp.addChild(ground);
                //Add the ground group to the scene group
                theScene.addChild(grndXfmGrp);
                //Create an appearance for the wall of the house
                Appearance wallApp = new Appearance();
                Color3f wallColour = new Color3f(0.5f,0.5f,0.5f);
                wallApp.setMaterial(new Material(wallColour,emissiveColour,
                                        wallColour,specularColour,shininess));
                //Create a cylinder that is the wall of the house
                Cylinder walls = new Cylinder(1.0f,1.0f,
                                        Primitive.GENERATE_NORMALS,wallApp);
                //Create a group that will be the root of the house
                TransformGroup house = new TransformGroup();
                //Add the walls to the house group
                house.addChild(walls);
                //Create an appearance for the roof
                Appearance roofApp = new Appearance();
                Color3f roofColour = new Color3f(0.5f,0.0f,0.0f);
                roofApp.setMaterial(new Material(roofColour,emissiveColour,
                                        roofColour,specularColour,shininess));
                //Create a cone that will be the roof
                Cone myRoof = new Cone(1.0f,1.0f,Primitive.GENERATE_NORMALS,roofApp);
                //Create the transform and transform group that will position the
                //roof on the house
                Transform3D roofXfm = new Transform3D();
                roofXfm.set(new Vector3f(0.0f,1.0f,0.0f));
                TransformGroup roofXfmGrp = new TransformGroup(roofXfm);
                //Add the roof to the roof transform group
                roofXfmGrp.addChild(myRoof);
                //Add the roof group to the house
		    house.addChild(roofXfmGrp);
                //Create an appearance for the tree trunks
                Appearance trunkApp = new Appearance();
                Color3f trunkColour = new Color3f(0.2f,0.2f,0.0f);
                trunkApp.setMaterial(new Material(trunkColour,emissiveColour,
                                        trunkColour,specularColour,shininess));
                //Create an appearance for the tree leaves
                Appearance leafApp = new Appearance();
                Color3f leafColour = new Color3f(0.0f,0.2f,0.0f);
                leafApp.setMaterial(new Material(leafColour,emissiveColour,
                                        leafColour,specularColour,shininess));
                //Create a transform and transform group for the tree
                Transform3D treeXfm = new Transform3D();
                treeXfm.set(new Vector3f(-2.0f,0.0f,0.5f));
                TransformGroup treeXfmGrp = new TransformGroup(treeXfm);
                //Create a cylinder for the tree trunk
                Cylinder myTrunk = new Cylinder(0.1f,1.0f,trunkApp);
                //Add the trunk to the tree group
                treeXfmGrp.addChild(myTrunk);
                //Create a transform and transform group for the tree leaves
                Transform3D leafXfm = new Transform3D();
                leafXfm.set(new Vector3f(0.0f,1.0f,0.0f));
                TransformGroup leafXfmGrp = new TransformGroup(leafXfm);
                //Create the leaves 
                Sphere myLeaf = new Sphere(0.5f,leafApp);
                //Add the leaves to the leaf group
                leafXfmGrp.addChild(myLeaf);
                //Add the leaf group to the tree group
                treeXfmGrp.addChild(leafXfmGrp);
                //Create another tree
                Transform3D tree1Xfm = new Transform3D();
                tree1Xfm.set(new Vector3f(1.4f,0.0f,-0.5f));
                TransformGroup tree1XfmGrp = new TransformGroup(tree1Xfm);
                Cylinder myTrunk1 = new Cylinder(0.1f,1.0f,trunkApp);
                tree1XfmGrp.addChild(myTrunk1);
                Transform3D leaf1Xfm = new Transform3D();
                leaf1Xfm.set(new Vector3f(0.0f,1.0f,0.0f));
                TransformGroup leaf1XfmGrp = new TransformGroup(leaf1Xfm);
                Sphere myLeaf1 = new Sphere(0.5f,leafApp);
                leaf1XfmGrp.addChild(myLeaf1);
                tree1XfmGrp.addChild(leaf1XfmGrp);
                //Create the final tree
                Transform3D tree2Xfm = new Transform3D();
                tree2Xfm.set(new Vector3f(1.2f,0.0f,1.0f));
                TransformGroup tree2XfmGrp = new TransformGroup(tree2Xfm);
                Cylinder myTrunk2 = new Cylinder(0.1f,1.0f,trunkApp);
                tree2XfmGrp.addChild(myTrunk2);
                Transform3D leaf2Xfm = new Transform3D();
                leaf2Xfm.set(new Vector3f(0.0f,1.0f,0.0f));
                TransformGroup leaf2XfmGrp = new TransformGroup(leaf2Xfm);
                Sphere myLeaf2 = new Sphere(0.5f,leafApp);
                leaf2XfmGrp.addChild(myLeaf2);
                tree2XfmGrp.addChild(leaf2XfmGrp); 
                //Put the scene together by adding all the groups
                //to the scene group
                theScene.addChild(house);
                theScene.addChild(treeXfmGrp);
                theScene.addChild(tree1XfmGrp);
                theScene.addChild(tree2XfmGrp);
                return theScene; 
	}
    /**
     * Handles the exit button action to quit the program.
     */
	public void actionPerformed(ActionEvent e) {
		dispose();
                System.exit(0);
	}
        public SimpleCombine() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch(buildShape()));
		setTitle("SimpleWorld");
		setSize(400,400);
		setLayout(new BorderLayout());
                add("Center", myCanvas3D);
                add("South",myButton);
                myButton.addActionListener(this);
                setVisible(true);
	}
	public static void main(String[] args) {
                  SimpleCombine sw = new SimpleCombine();
	}
}
